<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            // Stock management fields
            $table->boolean('stock_enabled')->default(false)->after('is_active');
            $table->integer('stock_quantity')->nullable()->after('stock_enabled');
            $table->integer('stock_remaining')->nullable()->after('stock_quantity');
            
            // Subscription fields
            $table->boolean('is_subscription')->default(false)->after('stock_remaining');
            $table->integer('subscription_duration')->nullable()->comment('Duration in days')->after('is_subscription');
        });

        // Add subscription fields to transactions table
        Schema::table('transactions', function (Blueprint $table) {
            $table->timestamp('subscription_starts_at')->nullable()->after('status');
            $table->timestamp('subscription_ends_at')->nullable()->after('subscription_starts_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->dropColumn([
                'stock_enabled',
                'stock_quantity',
                'stock_remaining',
                'is_subscription',
                'subscription_duration'
            ]);
        });

        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn([
                'subscription_starts_at',
                'subscription_ends_at'
            ]);
        });
    }
};